# bernoulli.py
# based on https://introcs.cs.princeton.edu/python/22module/bernoulli.py
# inputs: 20 100000

# Accept integers n and trials.
# Perform trials experiments, each of which counts the number
# of heads found when a fair coin is flipped n times. Then
# draw the results to standard draw. Also draw the predicted Gaussian
# distribution function, thereby allowing easy comparison of the
# experimental results to the theoretically predicted results.


import sys
import math, random

import matplotlib.pyplot as plt

# Return the value of the Gaussian probability function with mean
# and standard deviation at the given x value.

def pdf(x, mean=0.0, std=1.0):
  x = float(x - mean) / std
  return math.exp(-x*x/2.0) / math.sqrt(2.0*math.pi) / std



n,trials = map(int, input("n trials=? ").split())

freq = [0]*(n+1)
for t in range(trials):
  heads = 0
  for i in range(n):
    if random.random() > 0.5:
      heads += 1
  freq[heads] += 1
    
norm = [0.0]*(n+1)
for i in range(n+1):
  norm[i] = 1.0 * freq[i] / trials
    
phi = [0.0]*(n+1)
stddev = math.sqrt(n)/2.0
for i in range(n+1):
  phi[i] = pdf(i, n/2.0, stddev)

# using plotting
plt.bar(range(n+1), norm, label="norm", color="red")
plt.plot(range(n+1), phi, label="phi", color="green")
plt.title('Gaussian Prediction')
plt.legend()  # loc='lower center'
plt.show()

